//Code pour le capteur de température CTN analogique sur A0
//Définition des variables 
#include <math.h>

const int B = 3975;            // B value of the thermistor
const int R0 = 100000;            // R0 = 100k
const int pinTempSensor = A0;     // Grove - Temperature Sensor connect to A0

void setup()
{
  Serial.begin(9600);
}

void loop()
{
  //Mesure de la température
  int a = analogRead(pinTempSensor);
  float R = 1023.0 / a - 1.0;
  R = R0 * R;
  float temperature = 1.0 / (log(R / R0) / B + 1 / 298.15) - 273.15; // convert to temperature via datasheet

  Serial.print("temperature = ");
  Serial.println(temperature);

  delay(100);
}
